#ifndef _ROUTINES_H
#define _ROUTINES_H
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#define MAX_AUTH_LENGTH 1024 //Max size of the string used for authentication
#define MAX_KEY_LENGTH  1024 //Max size of the encryption key. (Both Registry & Generated)

#define FILEBUFFERSZ    1024

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool SaveRegistryValues(void);
bool GetRegistryValues(void);
bool OpenLogFile(void);
bool WaitOnApplicationToExit(void);
bool ConnectToServer(void);
bool CloseLogFile(void);
int CmdCmp(const char *sBuf, const char *sCmd);
int BreakCmdFromData(const char *sBuf, int iCmdLen, int iBufSz, char *sOutBuf);
int AppendDataToCmd(const char *sCmd, char *sData, int iDataSz, char *sOutBuf);
void WriteLog(int iClientId, char *sMessage);
void WriteSysLog(char *sMessage);
bool GetIPAddress(char *InputAddr, char *OutAddr);
char *ResolveHost(char *xHostName, int AddressNum);

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

DWORD WINAPI Timer_Thread(LPVOID);

extern char gsSessionLogDir[MAX_PATH];
extern char sExportFileTemp[MAX_PATH];
extern char gsPath[MAX_PATH];
extern char gsServerAddress[255];
extern char gsAuthKey[MAX_AUTH_LENGTH];
extern char gsAuthString[MAX_AUTH_LENGTH];

extern char gsCompanyName[64];
extern char gsCompanyPassword[64];

extern char gsSQLDataFiles[MAX_PATH]; // Relative to server.
extern char gsDefaultDBO[255];
extern char gsReplicationDB[255];

extern char gsSQLDriver[255];
extern char gsSQLPassword[255];
extern char gsSQLServer[255];
extern char gsSQLUserID[255];
extern char gsSQLDatabase[255];

extern bool gbShowSplashScreen;
extern bool gbKillApplication;
extern bool gbApplicationRunning;
extern bool gbConnectNow;

extern int giServerPort;
extern int giPingTimeoutMS;

extern DWORD gdwStartTime;
extern DWORD gdwStopTime;
extern DWORD gdwNextTime;
extern DWORD gdwConnectInterval;

extern DWORD Timer_Thread_ID;

extern HANDLE Timer_Thread_Handle;

extern FILE *gfhSessionLog;

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
